#pragma once

#include "otherfunctions.h"
#include "TreePropSheet.h"

#include "PPgGeneral.h"
#include "PPgConnection.h"
#include "PPgServer.h"
#include "PPgDirectories.h"
#include "PPgFiles.h"
#include "PPgStats.h"
#include "PPgNotify.h"
#include "Preferences.h"
#include "PPgTweaks.h"
#include "PPgDisplay.h"
#include "PPgSecurity.h"
#include "PPgWebServer.h"
#include "PPgScheduler.h"
#include "PPgMessages.h"

//==> PPgTabControl [shadow2004]
#include ".\NextEMF\PPG\PPgDisplay2.h"		//PPGDisplay2		Extended
#include ".\NextEMF\PPG\PPgConnection2.h"	//PPGConnection2	Hardlimit
#include ".\NextEMF\PPG\PPgConnection3.h"	//PPGConnection2	V-Limits
#include ".\NextEMF\PPG\PPgFiles2.h"		//PPGFiles2		Drop
#include ".\NextEMF\PPG\PPgSecurity2.h"		//PPGSecurity2		IPFilter
//<== PPgTabControl [shadow2004]

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
#include "PPgDebug.h"
#endif

class CPreferencesDlg : public CTreePropSheet
{
	DECLARE_DYNAMIC(CPreferencesDlg)

public:
	CPreferencesDlg();
	virtual ~CPreferencesDlg();
	
	CPPgGeneral		m_wndGeneral;
	CPPgConnection	m_wndConnection;
	CPPgServer		m_wndServer;
	CPPgDirectories	m_wndDirectories;
	CPPgFiles		m_wndFiles;
	CPPgStats		m_wndStats;
	CPPgNotify		m_wndNotify;
	CPPgTweaks		m_wndTweaks;
	CPPgDisplay		m_wndDisplay;
	CPPgSecurity	m_wndSecurity;
	CPPgWebServer	m_wndWebServer;
	CPPgScheduler	m_wndScheduler;
	CPPgMessages	m_wndMessages;

//==> PPgTabControl [shadow2004]
	CPPgDisplay2		m_wndDisplay2;			// Extended
	CPPgConnection2		m_wndConnection2;		// Hardlimit
	CPPgConnection3		m_wndConnection3;		// V Limit
	CPPgFiles2		m_wndFiles2;			// Drop
	CPPgSecurity2		m_wndSecurity2;			// IPFilter
//<== PPgTabControl [shadow2004]

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	CPPgDebug		m_wndDebug;
#endif

	void Localize();
	void SetStartPage(UINT uStartPageID);

protected:
	LPCTSTR m_pPshStartPage;
	bool m_bSaveIniFile;

	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();

//==> PPgTabControl [shadow2004]
public:	
	void SwitchTab(int page);

	int ActivePageGeneral;
	int ActivePageDisplay;
	int ActivePageConnection;
	int ActivePageServer;
	int ActivePageDirectory;
	int ActivePageFiles;
	int ActivePageNotify;
	int ActivePageStats;
	int ActivePageMessages;
	int ActivePageSecurity;
	int ActivePageScheduler;
	int ActivePageWebServer;
//	int	ActivePageTweaks;
	int ActivePageDebug;

	int StartPageGeneral;
	int StartPageDisplay;
	int StartPageConnection;
	int StartPageServer;
	int StartPageDirectory;
	int StartPageFiles;
	int StartPageNotify;
	int StartPageStats;
	int StartPageMessages;
	int StartPageSecurity;
	int StartPageScheduler;
	int StartPageWebServer;
//	int	StartPageTweaks;
	int StartPageDebug;
//<== PPgTabControl [shadow2004]
};
